/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.audits;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.audits.InspectorIssueCode;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/audits/InspectorIssueCodeSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/audits/InspectorIssueCode;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class InspectorIssueCodeSerializer
extends FCEnumSerializer<InspectorIssueCode> {
    @NotNull
    public static final InspectorIssueCodeSerializer INSTANCE = new InspectorIssueCodeSerializer();

    private InspectorIssueCodeSerializer() {
        super(Reflection.getOrCreateKotlinClass(InspectorIssueCode.class));
    }

    @Override
    @NotNull
    public InspectorIssueCode fromCode(@NotNull String code) {
        InspectorIssueCode inspectorIssueCode;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "CookieIssue": {
                inspectorIssueCode = InspectorIssueCode.CookieIssue.INSTANCE;
                break;
            }
            case "MixedContentIssue": {
                inspectorIssueCode = InspectorIssueCode.MixedContentIssue.INSTANCE;
                break;
            }
            case "BlockedByResponseIssue": {
                inspectorIssueCode = InspectorIssueCode.BlockedByResponseIssue.INSTANCE;
                break;
            }
            case "HeavyAdIssue": {
                inspectorIssueCode = InspectorIssueCode.HeavyAdIssue.INSTANCE;
                break;
            }
            case "ContentSecurityPolicyIssue": {
                inspectorIssueCode = InspectorIssueCode.ContentSecurityPolicyIssue.INSTANCE;
                break;
            }
            case "SharedArrayBufferIssue": {
                inspectorIssueCode = InspectorIssueCode.SharedArrayBufferIssue.INSTANCE;
                break;
            }
            case "LowTextContrastIssue": {
                inspectorIssueCode = InspectorIssueCode.LowTextContrastIssue.INSTANCE;
                break;
            }
            case "CorsIssue": {
                inspectorIssueCode = InspectorIssueCode.CorsIssue.INSTANCE;
                break;
            }
            case "AttributionReportingIssue": {
                inspectorIssueCode = InspectorIssueCode.AttributionReportingIssue.INSTANCE;
                break;
            }
            case "QuirksModeIssue": {
                inspectorIssueCode = InspectorIssueCode.QuirksModeIssue.INSTANCE;
                break;
            }
            case "PartitioningBlobURLIssue": {
                inspectorIssueCode = InspectorIssueCode.PartitioningBlobURLIssue.INSTANCE;
                break;
            }
            case "NavigatorUserAgentIssue": {
                inspectorIssueCode = InspectorIssueCode.NavigatorUserAgentIssue.INSTANCE;
                break;
            }
            case "GenericIssue": {
                inspectorIssueCode = InspectorIssueCode.GenericIssue.INSTANCE;
                break;
            }
            case "DeprecationIssue": {
                inspectorIssueCode = InspectorIssueCode.DeprecationIssue.INSTANCE;
                break;
            }
            case "ClientHintIssue": {
                inspectorIssueCode = InspectorIssueCode.ClientHintIssue.INSTANCE;
                break;
            }
            case "FederatedAuthRequestIssue": {
                inspectorIssueCode = InspectorIssueCode.FederatedAuthRequestIssue.INSTANCE;
                break;
            }
            case "BounceTrackingIssue": {
                inspectorIssueCode = InspectorIssueCode.BounceTrackingIssue.INSTANCE;
                break;
            }
            case "CookieDeprecationMetadataIssue": {
                inspectorIssueCode = InspectorIssueCode.CookieDeprecationMetadataIssue.INSTANCE;
                break;
            }
            case "StylesheetLoadingIssue": {
                inspectorIssueCode = InspectorIssueCode.StylesheetLoadingIssue.INSTANCE;
                break;
            }
            case "FederatedAuthUserInfoRequestIssue": {
                inspectorIssueCode = InspectorIssueCode.FederatedAuthUserInfoRequestIssue.INSTANCE;
                break;
            }
            case "PropertyRuleIssue": {
                inspectorIssueCode = InspectorIssueCode.PropertyRuleIssue.INSTANCE;
                break;
            }
            case "SharedDictionaryIssue": {
                inspectorIssueCode = InspectorIssueCode.SharedDictionaryIssue.INSTANCE;
                break;
            }
            case "ElementAccessibilityIssue": {
                inspectorIssueCode = InspectorIssueCode.ElementAccessibilityIssue.INSTANCE;
                break;
            }
            case "SRIMessageSignatureIssue": {
                inspectorIssueCode = InspectorIssueCode.SRIMessageSignatureIssue.INSTANCE;
                break;
            }
            case "UnencodedDigestIssue": {
                inspectorIssueCode = InspectorIssueCode.UnencodedDigestIssue.INSTANCE;
                break;
            }
            case "UserReidentificationIssue": {
                inspectorIssueCode = InspectorIssueCode.UserReidentificationIssue.INSTANCE;
                break;
            }
            default: {
                inspectorIssueCode = new InspectorIssueCode.NotDefinedInProtocol(code);
            }
        }
        return inspectorIssueCode;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull InspectorIssueCode value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        InspectorIssueCode inspectorIssueCode = value;
        if (inspectorIssueCode instanceof InspectorIssueCode.CookieIssue) {
            string2 = "CookieIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.MixedContentIssue) {
            string2 = "MixedContentIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.BlockedByResponseIssue) {
            string2 = "BlockedByResponseIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.HeavyAdIssue) {
            string2 = "HeavyAdIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.ContentSecurityPolicyIssue) {
            string2 = "ContentSecurityPolicyIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.SharedArrayBufferIssue) {
            string2 = "SharedArrayBufferIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.LowTextContrastIssue) {
            string2 = "LowTextContrastIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.CorsIssue) {
            string2 = "CorsIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.AttributionReportingIssue) {
            string2 = "AttributionReportingIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.QuirksModeIssue) {
            string2 = "QuirksModeIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.PartitioningBlobURLIssue) {
            string2 = "PartitioningBlobURLIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.NavigatorUserAgentIssue) {
            string2 = "NavigatorUserAgentIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.GenericIssue) {
            string2 = "GenericIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.DeprecationIssue) {
            string2 = "DeprecationIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.ClientHintIssue) {
            string2 = "ClientHintIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.FederatedAuthRequestIssue) {
            string2 = "FederatedAuthRequestIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.BounceTrackingIssue) {
            string2 = "BounceTrackingIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.CookieDeprecationMetadataIssue) {
            string2 = "CookieDeprecationMetadataIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.StylesheetLoadingIssue) {
            string2 = "StylesheetLoadingIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.FederatedAuthUserInfoRequestIssue) {
            string2 = "FederatedAuthUserInfoRequestIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.PropertyRuleIssue) {
            string2 = "PropertyRuleIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.SharedDictionaryIssue) {
            string2 = "SharedDictionaryIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.ElementAccessibilityIssue) {
            string2 = "ElementAccessibilityIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.SRIMessageSignatureIssue) {
            string2 = "SRIMessageSignatureIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.UnencodedDigestIssue) {
            string2 = "UnencodedDigestIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.UserReidentificationIssue) {
            string2 = "UserReidentificationIssue";
        } else if (inspectorIssueCode instanceof InspectorIssueCode.NotDefinedInProtocol) {
            string2 = ((InspectorIssueCode.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

