/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.backgroundservice;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.backgroundservice.ServiceName;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/backgroundservice/ServiceNameSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/backgroundservice/ServiceName;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class ServiceNameSerializer
extends FCEnumSerializer<ServiceName> {
    @NotNull
    public static final ServiceNameSerializer INSTANCE = new ServiceNameSerializer();

    private ServiceNameSerializer() {
        super(Reflection.getOrCreateKotlinClass(ServiceName.class));
    }

    @Override
    @NotNull
    public ServiceName fromCode(@NotNull String code) {
        ServiceName serviceName;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "backgroundFetch": {
                serviceName = ServiceName.backgroundFetch.INSTANCE;
                break;
            }
            case "backgroundSync": {
                serviceName = ServiceName.backgroundSync.INSTANCE;
                break;
            }
            case "pushMessaging": {
                serviceName = ServiceName.pushMessaging.INSTANCE;
                break;
            }
            case "notifications": {
                serviceName = ServiceName.notifications.INSTANCE;
                break;
            }
            case "paymentHandler": {
                serviceName = ServiceName.paymentHandler.INSTANCE;
                break;
            }
            case "periodicBackgroundSync": {
                serviceName = ServiceName.periodicBackgroundSync.INSTANCE;
                break;
            }
            default: {
                serviceName = new ServiceName.NotDefinedInProtocol(code);
            }
        }
        return serviceName;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull ServiceName value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ServiceName serviceName = value;
        if (serviceName instanceof ServiceName.backgroundFetch) {
            string2 = "backgroundFetch";
        } else if (serviceName instanceof ServiceName.backgroundSync) {
            string2 = "backgroundSync";
        } else if (serviceName instanceof ServiceName.pushMessaging) {
            string2 = "pushMessaging";
        } else if (serviceName instanceof ServiceName.notifications) {
            string2 = "notifications";
        } else if (serviceName instanceof ServiceName.paymentHandler) {
            string2 = "paymentHandler";
        } else if (serviceName instanceof ServiceName.periodicBackgroundSync) {
            string2 = "periodicBackgroundSync";
        } else if (serviceName instanceof ServiceName.NotDefinedInProtocol) {
            string2 = ((ServiceName.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

