/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.browser;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.browser.BrowserCommandId;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/browser/BrowserCommandIdSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/browser/BrowserCommandId;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class BrowserCommandIdSerializer
extends FCEnumSerializer<BrowserCommandId> {
    @NotNull
    public static final BrowserCommandIdSerializer INSTANCE = new BrowserCommandIdSerializer();

    private BrowserCommandIdSerializer() {
        super(Reflection.getOrCreateKotlinClass(BrowserCommandId.class));
    }

    @Override
    @NotNull
    public BrowserCommandId fromCode(@NotNull String code) {
        BrowserCommandId browserCommandId;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "openTabSearch": {
                browserCommandId = BrowserCommandId.openTabSearch.INSTANCE;
                break;
            }
            case "closeTabSearch": {
                browserCommandId = BrowserCommandId.closeTabSearch.INSTANCE;
                break;
            }
            case "openGlic": {
                browserCommandId = BrowserCommandId.openGlic.INSTANCE;
                break;
            }
            default: {
                browserCommandId = new BrowserCommandId.NotDefinedInProtocol(code);
            }
        }
        return browserCommandId;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull BrowserCommandId value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BrowserCommandId browserCommandId = value;
        if (browserCommandId instanceof BrowserCommandId.openTabSearch) {
            string2 = "openTabSearch";
        } else if (browserCommandId instanceof BrowserCommandId.closeTabSearch) {
            string2 = "closeTabSearch";
        } else if (browserCommandId instanceof BrowserCommandId.openGlic) {
            string2 = "openGlic";
        } else if (browserCommandId instanceof BrowserCommandId.NotDefinedInProtocol) {
            string2 = ((BrowserCommandId.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

