/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.emulation;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.emulation.SensorType;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/emulation/SensorTypeSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/emulation/SensorType;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class SensorTypeSerializer
extends FCEnumSerializer<SensorType> {
    @NotNull
    public static final SensorTypeSerializer INSTANCE = new SensorTypeSerializer();

    private SensorTypeSerializer() {
        super(Reflection.getOrCreateKotlinClass(SensorType.class));
    }

    @Override
    @NotNull
    public SensorType fromCode(@NotNull String code) {
        SensorType sensorType;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "absolute-orientation": {
                sensorType = SensorType.absoluteOrientation.INSTANCE;
                break;
            }
            case "accelerometer": {
                sensorType = SensorType.accelerometer.INSTANCE;
                break;
            }
            case "ambient-light": {
                sensorType = SensorType.ambientLight.INSTANCE;
                break;
            }
            case "gravity": {
                sensorType = SensorType.gravity.INSTANCE;
                break;
            }
            case "gyroscope": {
                sensorType = SensorType.gyroscope.INSTANCE;
                break;
            }
            case "linear-acceleration": {
                sensorType = SensorType.linearAcceleration.INSTANCE;
                break;
            }
            case "magnetometer": {
                sensorType = SensorType.magnetometer.INSTANCE;
                break;
            }
            case "relative-orientation": {
                sensorType = SensorType.relativeOrientation.INSTANCE;
                break;
            }
            default: {
                sensorType = new SensorType.NotDefinedInProtocol(code);
            }
        }
        return sensorType;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull SensorType value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SensorType sensorType = value;
        if (sensorType instanceof SensorType.absoluteOrientation) {
            string2 = "absolute-orientation";
        } else if (sensorType instanceof SensorType.accelerometer) {
            string2 = "accelerometer";
        } else if (sensorType instanceof SensorType.ambientLight) {
            string2 = "ambient-light";
        } else if (sensorType instanceof SensorType.gravity) {
            string2 = "gravity";
        } else if (sensorType instanceof SensorType.gyroscope) {
            string2 = "gyroscope";
        } else if (sensorType instanceof SensorType.linearAcceleration) {
            string2 = "linear-acceleration";
        } else if (sensorType instanceof SensorType.magnetometer) {
            string2 = "magnetometer";
        } else if (sensorType instanceof SensorType.relativeOrientation) {
            string2 = "relative-orientation";
        } else if (sensorType instanceof SensorType.NotDefinedInProtocol) {
            string2 = ((SensorType.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

