/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.network;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.network.ContentEncoding;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/network/ContentEncodingSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/network/ContentEncoding;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class ContentEncodingSerializer
extends FCEnumSerializer<ContentEncoding> {
    @NotNull
    public static final ContentEncodingSerializer INSTANCE = new ContentEncodingSerializer();

    private ContentEncodingSerializer() {
        super(Reflection.getOrCreateKotlinClass(ContentEncoding.class));
    }

    @Override
    @NotNull
    public ContentEncoding fromCode(@NotNull String code) {
        ContentEncoding contentEncoding;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "deflate": {
                contentEncoding = ContentEncoding.deflate.INSTANCE;
                break;
            }
            case "gzip": {
                contentEncoding = ContentEncoding.gzip.INSTANCE;
                break;
            }
            case "br": {
                contentEncoding = ContentEncoding.br.INSTANCE;
                break;
            }
            case "zstd": {
                contentEncoding = ContentEncoding.zstd.INSTANCE;
                break;
            }
            default: {
                contentEncoding = new ContentEncoding.NotDefinedInProtocol(code);
            }
        }
        return contentEncoding;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull ContentEncoding value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ContentEncoding contentEncoding = value;
        if (contentEncoding instanceof ContentEncoding.deflate) {
            string2 = "deflate";
        } else if (contentEncoding instanceof ContentEncoding.gzip) {
            string2 = "gzip";
        } else if (contentEncoding instanceof ContentEncoding.br) {
            string2 = "br";
        } else if (contentEncoding instanceof ContentEncoding.zstd) {
            string2 = "zstd";
        } else if (contentEncoding instanceof ContentEncoding.NotDefinedInProtocol) {
            string2 = ((ContentEncoding.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

