/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.network;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.network.IpProxyStatus;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/network/IpProxyStatusSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/network/IpProxyStatus;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class IpProxyStatusSerializer
extends FCEnumSerializer<IpProxyStatus> {
    @NotNull
    public static final IpProxyStatusSerializer INSTANCE = new IpProxyStatusSerializer();

    private IpProxyStatusSerializer() {
        super(Reflection.getOrCreateKotlinClass(IpProxyStatus.class));
    }

    @Override
    @NotNull
    public IpProxyStatus fromCode(@NotNull String code) {
        IpProxyStatus ipProxyStatus;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "Available": {
                ipProxyStatus = IpProxyStatus.Available.INSTANCE;
                break;
            }
            case "FeatureNotEnabled": {
                ipProxyStatus = IpProxyStatus.FeatureNotEnabled.INSTANCE;
                break;
            }
            case "MaskedDomainListNotEnabled": {
                ipProxyStatus = IpProxyStatus.MaskedDomainListNotEnabled.INSTANCE;
                break;
            }
            case "MaskedDomainListNotPopulated": {
                ipProxyStatus = IpProxyStatus.MaskedDomainListNotPopulated.INSTANCE;
                break;
            }
            case "AuthTokensUnavailable": {
                ipProxyStatus = IpProxyStatus.AuthTokensUnavailable.INSTANCE;
                break;
            }
            case "Unavailable": {
                ipProxyStatus = IpProxyStatus.Unavailable.INSTANCE;
                break;
            }
            case "BypassedByDevTools": {
                ipProxyStatus = IpProxyStatus.BypassedByDevTools.INSTANCE;
                break;
            }
            default: {
                ipProxyStatus = new IpProxyStatus.NotDefinedInProtocol(code);
            }
        }
        return ipProxyStatus;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull IpProxyStatus value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        IpProxyStatus ipProxyStatus = value;
        if (ipProxyStatus instanceof IpProxyStatus.Available) {
            string2 = "Available";
        } else if (ipProxyStatus instanceof IpProxyStatus.FeatureNotEnabled) {
            string2 = "FeatureNotEnabled";
        } else if (ipProxyStatus instanceof IpProxyStatus.MaskedDomainListNotEnabled) {
            string2 = "MaskedDomainListNotEnabled";
        } else if (ipProxyStatus instanceof IpProxyStatus.MaskedDomainListNotPopulated) {
            string2 = "MaskedDomainListNotPopulated";
        } else if (ipProxyStatus instanceof IpProxyStatus.AuthTokensUnavailable) {
            string2 = "AuthTokensUnavailable";
        } else if (ipProxyStatus instanceof IpProxyStatus.Unavailable) {
            string2 = "Unavailable";
        } else if (ipProxyStatus instanceof IpProxyStatus.BypassedByDevTools) {
            string2 = "BypassedByDevTools";
        } else if (ipProxyStatus instanceof IpProxyStatus.NotDefinedInProtocol) {
            string2 = ((IpProxyStatus.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

