/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.runtime;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.runtime.PropertyPreviewType;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/runtime/PropertyPreviewTypeSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/runtime/PropertyPreviewType;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class PropertyPreviewTypeSerializer
extends FCEnumSerializer<PropertyPreviewType> {
    @NotNull
    public static final PropertyPreviewTypeSerializer INSTANCE = new PropertyPreviewTypeSerializer();

    private PropertyPreviewTypeSerializer() {
        super(Reflection.getOrCreateKotlinClass(PropertyPreviewType.class));
    }

    @Override
    @NotNull
    public PropertyPreviewType fromCode(@NotNull String code) {
        PropertyPreviewType propertyPreviewType;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "object": {
                propertyPreviewType = PropertyPreviewType.object.INSTANCE;
                break;
            }
            case "function": {
                propertyPreviewType = PropertyPreviewType.function.INSTANCE;
                break;
            }
            case "undefined": {
                propertyPreviewType = PropertyPreviewType.undefined.INSTANCE;
                break;
            }
            case "string": {
                propertyPreviewType = PropertyPreviewType.string.INSTANCE;
                break;
            }
            case "number": {
                propertyPreviewType = PropertyPreviewType.number.INSTANCE;
                break;
            }
            case "boolean": {
                propertyPreviewType = PropertyPreviewType.boolean.INSTANCE;
                break;
            }
            case "symbol": {
                propertyPreviewType = PropertyPreviewType.symbol.INSTANCE;
                break;
            }
            case "accessor": {
                propertyPreviewType = PropertyPreviewType.accessor.INSTANCE;
                break;
            }
            case "bigint": {
                propertyPreviewType = PropertyPreviewType.bigint.INSTANCE;
                break;
            }
            default: {
                propertyPreviewType = new PropertyPreviewType.NotDefinedInProtocol(code);
            }
        }
        return propertyPreviewType;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull PropertyPreviewType value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PropertyPreviewType propertyPreviewType = value;
        if (propertyPreviewType instanceof PropertyPreviewType.object) {
            string2 = "object";
        } else if (propertyPreviewType instanceof PropertyPreviewType.function) {
            string2 = "function";
        } else if (propertyPreviewType instanceof PropertyPreviewType.undefined) {
            string2 = "undefined";
        } else if (propertyPreviewType instanceof PropertyPreviewType.string) {
            string2 = "string";
        } else if (propertyPreviewType instanceof PropertyPreviewType.number) {
            string2 = "number";
        } else if (propertyPreviewType instanceof PropertyPreviewType.boolean) {
            string2 = "boolean";
        } else if (propertyPreviewType instanceof PropertyPreviewType.symbol) {
            string2 = "symbol";
        } else if (propertyPreviewType instanceof PropertyPreviewType.accessor) {
            string2 = "accessor";
        } else if (propertyPreviewType instanceof PropertyPreviewType.bigint) {
            string2 = "bigint";
        } else if (propertyPreviewType instanceof PropertyPreviewType.NotDefinedInProtocol) {
            string2 = ((PropertyPreviewType.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

