/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.webauthn;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.webauthn.AuthenticatorTransport;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/webauthn/AuthenticatorTransportSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/webauthn/AuthenticatorTransport;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class AuthenticatorTransportSerializer
extends FCEnumSerializer<AuthenticatorTransport> {
    @NotNull
    public static final AuthenticatorTransportSerializer INSTANCE = new AuthenticatorTransportSerializer();

    private AuthenticatorTransportSerializer() {
        super(Reflection.getOrCreateKotlinClass(AuthenticatorTransport.class));
    }

    @Override
    @NotNull
    public AuthenticatorTransport fromCode(@NotNull String code) {
        AuthenticatorTransport authenticatorTransport;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "usb": {
                authenticatorTransport = AuthenticatorTransport.usb.INSTANCE;
                break;
            }
            case "nfc": {
                authenticatorTransport = AuthenticatorTransport.nfc.INSTANCE;
                break;
            }
            case "ble": {
                authenticatorTransport = AuthenticatorTransport.ble.INSTANCE;
                break;
            }
            case "cable": {
                authenticatorTransport = AuthenticatorTransport.cable.INSTANCE;
                break;
            }
            case "internal": {
                authenticatorTransport = AuthenticatorTransport.internal.INSTANCE;
                break;
            }
            default: {
                authenticatorTransport = new AuthenticatorTransport.NotDefinedInProtocol(code);
            }
        }
        return authenticatorTransport;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull AuthenticatorTransport value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AuthenticatorTransport authenticatorTransport = value;
        if (authenticatorTransport instanceof AuthenticatorTransport.usb) {
            string2 = "usb";
        } else if (authenticatorTransport instanceof AuthenticatorTransport.nfc) {
            string2 = "nfc";
        } else if (authenticatorTransport instanceof AuthenticatorTransport.ble) {
            string2 = "ble";
        } else if (authenticatorTransport instanceof AuthenticatorTransport.cable) {
            string2 = "cable";
        } else if (authenticatorTransport instanceof AuthenticatorTransport.internal) {
            string2 = "internal";
        } else if (authenticatorTransport instanceof AuthenticatorTransport.NotDefinedInProtocol) {
            string2 = ((AuthenticatorTransport.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

