package org.hildan.chrome.devtools.domains.domdebugger

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.dom.BackendNodeId
import org.hildan.chrome.devtools.domains.runtime.RemoteObject
import org.hildan.chrome.devtools.domains.runtime.ScriptId
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * DOM breakpoint type.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger/#type-DOMBreakpointType)
 */
@Serializable
public enum class DOMBreakpointType {
  `subtree-modified`,
  `attribute-modified`,
  `node-removed`,
}

/**
 * CSP Violation type.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger/#type-CSPViolationType)
 */
@ExperimentalChromeApi
@Serializable
public enum class CSPViolationType {
  `trustedtype-sink-violation`,
  `trustedtype-policy-violation`,
}

/**
 * Object event listener.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger/#type-EventListener)
 */
@Serializable
public data class EventListener(
  /**
   * `EventListener`'s type.
   */
  public val type: String,
  /**
   * `EventListener`'s useCapture.
   */
  public val useCapture: Boolean,
  /**
   * `EventListener`'s passive flag.
   */
  public val passive: Boolean,
  /**
   * `EventListener`'s once flag.
   */
  public val once: Boolean,
  /**
   * Script id of the handler code.
   */
  public val scriptId: ScriptId,
  /**
   * Line number in the script (0-based).
   */
  public val lineNumber: Int,
  /**
   * Column number in the script (0-based).
   */
  public val columnNumber: Int,
  /**
   * Event handler function value.
   */
  public val handler: RemoteObject? = null,
  /**
   * Event original handler function value.
   */
  public val originalHandler: RemoteObject? = null,
  /**
   * Node the listener is added to (if any).
   */
  public val backendNodeId: BackendNodeId? = null
)
