package org.hildan.chrome.devtools.domains.emulation.events

import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

@Serializable
public sealed class EmulationEvent {
  /**
   * Notification sent after the virtual time budget for the current VirtualTimePolicy has run out.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#event-virtualTimeBudgetExpired)
   */
  @ExperimentalChromeApi
  @Serializable
  public object VirtualTimeBudgetExpiredEvent : EmulationEvent()
}
