package org.hildan.chrome.devtools.domains.headlessexperimental

import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable

/**
 * Encoding options for a screenshot.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeadlessExperimental/#type-ScreenshotParams)
 */
@Serializable
public data class ScreenshotParams(
  /**
   * Image compression format (defaults to png).
   */
  public val format: String? = null,
  /**
   * Compression quality from range [0..100] (jpeg only).
   */
  public val quality: Int? = null
)
