package org.hildan.chrome.devtools.domains.log

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.network.RequestId
import org.hildan.chrome.devtools.domains.runtime.RemoteObject
import org.hildan.chrome.devtools.domains.runtime.StackTrace
import org.hildan.chrome.devtools.domains.runtime.Timestamp

/**
 * Log entry.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#type-LogEntry)
 */
@Serializable
public data class LogEntry(
  /**
   * Log entry source.
   */
  public val source: String,
  /**
   * Log entry severity.
   */
  public val level: String,
  /**
   * Logged text.
   */
  public val text: String,
  /**
   * Timestamp when this entry was added.
   */
  public val timestamp: Timestamp,
  /**
   * URL of the resource if known.
   */
  public val url: String? = null,
  /**
   * Line number in the resource.
   */
  public val lineNumber: Int? = null,
  /**
   * JavaScript stack trace.
   */
  public val stackTrace: StackTrace? = null,
  /**
   * Identifier of the network request associated with this entry.
   */
  public val networkRequestId: RequestId? = null,
  /**
   * Identifier of the worker associated with this entry.
   */
  public val workerId: String? = null,
  /**
   * Call arguments.
   */
  public val args: List<RemoteObject>? = null
)

/**
 * Violation configuration setting.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#type-ViolationSetting)
 */
@Serializable
public data class ViolationSetting(
  /**
   * Violation type.
   */
  public val name: String,
  /**
   * Time threshold to trigger upon.
   */
  public val threshold: Double
)
