package org.hildan.chrome.devtools.domains.input

import kotlin.Double
import kotlin.Int
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Input/#type-TouchPoint)
 */
@Serializable
public data class TouchPoint(
  /**
   * X coordinate of the event relative to the main frame's viewport in CSS pixels.
   */
  public val x: Double,
  /**
   * Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to
   * the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.
   */
  public val y: Double,
  /**
   * X radius of the touch area (default: 1.0).
   */
  public val radiusX: Double? = null,
  /**
   * Y radius of the touch area (default: 1.0).
   */
  public val radiusY: Double? = null,
  /**
   * Rotation angle (default: 0.0).
   */
  public val rotationAngle: Double? = null,
  /**
   * Force (default: 1.0).
   */
  public val force: Double? = null,
  /**
   * The normalized tangential pressure, which has a range of [-1,1] (default: 0).
   */
  @ExperimentalChromeApi
  public val tangentialPressure: Double? = null,
  /**
   * The plane angle between the Y-Z plane and the plane containing both the stylus axis and the Y
   * axis, in degrees of the range [-90,90], a positive tiltX is to the right (default: 0)
   */
  @ExperimentalChromeApi
  public val tiltX: Int? = null,
  /**
   * The plane angle between the X-Z plane and the plane containing both the stylus axis and the X
   * axis, in degrees of the range [-90,90], a positive tiltY is towards the user (default: 0).
   */
  @ExperimentalChromeApi
  public val tiltY: Int? = null,
  /**
   * The clockwise rotation of a pen stylus around its own major axis, in degrees in the range
   * [0,359] (default: 0).
   */
  @ExperimentalChromeApi
  public val twist: Int? = null,
  /**
   * Identifier used to track touch sources between events, must be unique within an event.
   */
  public val id: Double? = null
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Input/#type-GestureSourceType)
 */
@ExperimentalChromeApi
@Serializable
public enum class GestureSourceType {
  default,
  touch,
  mouse,
}

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Input/#type-MouseButton)
 */
@Serializable
public enum class MouseButton {
  none,
  left,
  middle,
  right,
  back,
  forward,
}

/**
 * UTC time in seconds, counted from January 1, 1970.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Input/#type-TimeSinceEpoch)
 */
public typealias TimeSinceEpoch = Double
