package org.hildan.chrome.devtools.targets

import kotlin.Deprecated
import org.hildan.chrome.devtools.domains.audits.AuditsDomain
import org.hildan.chrome.devtools.domains.backgroundservice.BackgroundServiceDomain
import org.hildan.chrome.devtools.domains.browser.BrowserDomain
import org.hildan.chrome.devtools.domains.dom.DOMDomain
import org.hildan.chrome.devtools.domains.emulation.EmulationDomain
import org.hildan.chrome.devtools.domains.fetch.FetchDomain
import org.hildan.chrome.devtools.domains.input.InputDomain
import org.hildan.chrome.devtools.domains.inspector.InspectorDomain
import org.hildan.chrome.devtools.domains.io.IODomain
import org.hildan.chrome.devtools.domains.log.LogDomain
import org.hildan.chrome.devtools.domains.memory.MemoryDomain
import org.hildan.chrome.devtools.domains.network.NetworkDomain
import org.hildan.chrome.devtools.domains.overlay.OverlayDomain
import org.hildan.chrome.devtools.domains.page.PageDomain
import org.hildan.chrome.devtools.domains.runtime.RuntimeDomain
import org.hildan.chrome.devtools.domains.schema.SchemaDomain
import org.hildan.chrome.devtools.domains.security.SecurityDomain
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerDomain
import org.hildan.chrome.devtools.domains.storage.StorageDomain
import org.hildan.chrome.devtools.domains.target.TargetDomain
import org.hildan.chrome.devtools.domains.tracing.TracingDomain
import org.hildan.chrome.devtools.domains.webauthn.WebAuthnDomain
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Represents the available domain APIs in RenderFrame targets
 */
public interface RenderFrameTarget {
  /**
   * Audits domain allows investigation of page violations and possible improvements.
   */
  @ExperimentalChromeApi
  public val audits: AuditsDomain

  /**
   * Defines events for background web platform features.
   */
  @ExperimentalChromeApi
  public val backgroundService: BackgroundServiceDomain

  /**
   * The Browser domain defines methods and events for browser managing.
   */
  public val browser: BrowserDomain

  /**
   * This domain exposes DOM read/write operations. Each DOM Node is represented with its mirror
   * object
   * that has an `id`. This `id` can be used to get additional information on the Node, resolve it
   * into
   * the JavaScript object wrapper, etc. It is important that client receives DOM events only for
   * the
   * nodes that are known to the client. Backend keeps track of the nodes that were sent to the
   * client
   * and never sends the same node twice. It is client's responsibility to collect information about
   * the nodes that were sent to the client.<p>Note that `iframe` owner elements will return
   * corresponding document elements as their child nodes.</p>
   */
  public val dom: DOMDomain

  /**
   * This domain emulates different environments for the page.
   */
  public val emulation: EmulationDomain

  /**
   * Input/Output operations for streams produced by DevTools.
   */
  public val io: IODomain

  public val input: InputDomain

  @ExperimentalChromeApi
  public val inspector: InspectorDomain

  /**
   * Provides access to log entries.
   */
  public val log: LogDomain

  @ExperimentalChromeApi
  public val memory: MemoryDomain

  /**
   * Network domain allows tracking network activities of the page. It exposes information about
   * http,
   * file, data and other requests and responses, their headers, bodies, timing, etc.
   */
  public val network: NetworkDomain

  /**
   * This domain provides various functionality related to drawing atop the inspected page.
   */
  @ExperimentalChromeApi
  public val overlay: OverlayDomain

  /**
   * Actions and events related to the inspected page belong to the page domain.
   */
  public val page: PageDomain

  /**
   * Security
   */
  public val security: SecurityDomain

  @ExperimentalChromeApi
  public val serviceWorker: ServiceWorkerDomain

  @ExperimentalChromeApi
  public val storage: StorageDomain

  /**
   * Supports additional targets discovery and allows to attach to them.
   */
  public val target: TargetDomain

  @ExperimentalChromeApi
  public val tracing: TracingDomain

  /**
   * A domain for letting clients substitute browser's network layer with client code.
   */
  public val fetch: FetchDomain

  /**
   * This domain allows configuring virtual authenticators to test the WebAuthn
   * API.
   */
  @ExperimentalChromeApi
  public val webAuthn: WebAuthnDomain

  /**
   * Runtime domain exposes JavaScript runtime by means of remote evaluation and mirror objects.
   * Evaluation results are returned as mirror object that expose object type, string representation
   * and unique identifier that can be used for further object reference. Original objects are
   * maintained in memory unless they are either explicitly released or are released along with the
   * other objects in their object group.
   */
  public val runtime: RuntimeDomain

  /**
   * This domain is deprecated.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val schema: SchemaDomain
}
