package org.hildan.chrome.devtools.targets

import kotlin.Deprecated
import org.hildan.chrome.devtools.domains.accessibility.AccessibilityDomain
import org.hildan.chrome.devtools.domains.animation.AnimationDomain
import org.hildan.chrome.devtools.domains.applicationcache.ApplicationCacheDomain
import org.hildan.chrome.devtools.domains.audits.AuditsDomain
import org.hildan.chrome.devtools.domains.backgroundservice.BackgroundServiceDomain
import org.hildan.chrome.devtools.domains.browser.BrowserDomain
import org.hildan.chrome.devtools.domains.cachestorage.CacheStorageDomain
import org.hildan.chrome.devtools.domains.cast.CastDomain
import org.hildan.chrome.devtools.domains.console.ConsoleDomain
import org.hildan.chrome.devtools.domains.css.CSSDomain
import org.hildan.chrome.devtools.domains.database.DatabaseDomain
import org.hildan.chrome.devtools.domains.debugger.DebuggerDomain
import org.hildan.chrome.devtools.domains.deviceorientation.DeviceOrientationDomain
import org.hildan.chrome.devtools.domains.dom.DOMDomain
import org.hildan.chrome.devtools.domains.domdebugger.DOMDebuggerDomain
import org.hildan.chrome.devtools.domains.domsnapshot.DOMSnapshotDomain
import org.hildan.chrome.devtools.domains.domstorage.DOMStorageDomain
import org.hildan.chrome.devtools.domains.emulation.EmulationDomain
import org.hildan.chrome.devtools.domains.fetch.FetchDomain
import org.hildan.chrome.devtools.domains.headlessexperimental.HeadlessExperimentalDomain
import org.hildan.chrome.devtools.domains.heapprofiler.HeapProfilerDomain
import org.hildan.chrome.devtools.domains.indexeddb.IndexedDBDomain
import org.hildan.chrome.devtools.domains.input.InputDomain
import org.hildan.chrome.devtools.domains.inspector.InspectorDomain
import org.hildan.chrome.devtools.domains.io.IODomain
import org.hildan.chrome.devtools.domains.layertree.LayerTreeDomain
import org.hildan.chrome.devtools.domains.log.LogDomain
import org.hildan.chrome.devtools.domains.media.MediaDomain
import org.hildan.chrome.devtools.domains.memory.MemoryDomain
import org.hildan.chrome.devtools.domains.network.NetworkDomain
import org.hildan.chrome.devtools.domains.overlay.OverlayDomain
import org.hildan.chrome.devtools.domains.page.PageDomain
import org.hildan.chrome.devtools.domains.performance.PerformanceDomain
import org.hildan.chrome.devtools.domains.performancetimeline.PerformanceTimelineDomain
import org.hildan.chrome.devtools.domains.profiler.ProfilerDomain
import org.hildan.chrome.devtools.domains.runtime.RuntimeDomain
import org.hildan.chrome.devtools.domains.schema.SchemaDomain
import org.hildan.chrome.devtools.domains.security.SecurityDomain
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerDomain
import org.hildan.chrome.devtools.domains.storage.StorageDomain
import org.hildan.chrome.devtools.domains.systeminfo.SystemInfoDomain
import org.hildan.chrome.devtools.domains.target.TargetDomain
import org.hildan.chrome.devtools.domains.tethering.TetheringDomain
import org.hildan.chrome.devtools.domains.tracing.TracingDomain
import org.hildan.chrome.devtools.domains.webaudio.WebAudioDomain
import org.hildan.chrome.devtools.domains.webauthn.WebAuthnDomain
import org.hildan.chrome.devtools.protocol.ChromeDPSession
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Implementation of all target interfaces by exposing all domain APIs
 */
internal class SimpleTarget(
  session: ChromeDPSession
) : BrowserTarget, RenderFrameTarget, WorkerTarget, ServiceWorkerTarget, SharedWorkerTarget,
    AllDomainsTarget {
  @ExperimentalChromeApi
  public override val accessibility: AccessibilityDomain by lazy { AccessibilityDomain(session) }

  @ExperimentalChromeApi
  public override val animation: AnimationDomain by lazy { AnimationDomain(session) }

  @ExperimentalChromeApi
  public override val applicationCache: ApplicationCacheDomain by lazy {
      ApplicationCacheDomain(session) }

  /**
   * Audits domain allows investigation of page violations and possible improvements.
   */
  @ExperimentalChromeApi
  public override val audits: AuditsDomain by lazy { AuditsDomain(session) }

  /**
   * Defines events for background web platform features.
   */
  @ExperimentalChromeApi
  public override val backgroundService: BackgroundServiceDomain by lazy {
      BackgroundServiceDomain(session) }

  /**
   * The Browser domain defines methods and events for browser managing.
   */
  public override val browser: BrowserDomain by lazy { BrowserDomain(session) }

  /**
   * This domain exposes CSS read/write operations. All CSS objects (stylesheets, rules, and styles)
   * have an associated `id` used in subsequent operations on the related object. Each object type
   * has
   * a specific `id` structure, and those are not interchangeable between objects of different
   * kinds.
   * CSS objects can be loaded using the `get*ForNode()` calls (which accept a DOM node id). A
   * client
   * can also keep track of stylesheets via the `styleSheetAdded`/`styleSheetRemoved` events and
   * subsequently load the required stylesheet contents using the `getStyleSheet[Text]()` methods.
   */
  @ExperimentalChromeApi
  public override val css: CSSDomain by lazy { CSSDomain(session) }

  @ExperimentalChromeApi
  public override val cacheStorage: CacheStorageDomain by lazy { CacheStorageDomain(session) }

  /**
   * A domain for interacting with Cast, Presentation API, and Remote Playback API
   * functionalities.
   */
  @ExperimentalChromeApi
  public override val cast: CastDomain by lazy { CastDomain(session) }

  /**
   * This domain exposes DOM read/write operations. Each DOM Node is represented with its mirror
   * object
   * that has an `id`. This `id` can be used to get additional information on the Node, resolve it
   * into
   * the JavaScript object wrapper, etc. It is important that client receives DOM events only for
   * the
   * nodes that are known to the client. Backend keeps track of the nodes that were sent to the
   * client
   * and never sends the same node twice. It is client's responsibility to collect information about
   * the nodes that were sent to the client.<p>Note that `iframe` owner elements will return
   * corresponding document elements as their child nodes.</p>
   */
  public override val dom: DOMDomain by lazy { DOMDomain(session) }

  /**
   * DOM debugging allows setting breakpoints on particular DOM operations and events. JavaScript
   * execution will stop on these operations as if there was a regular breakpoint set.
   */
  public override val domDebugger: DOMDebuggerDomain by lazy { DOMDebuggerDomain(session) }

  /**
   * This domain facilitates obtaining document snapshots with DOM, layout, and style information.
   */
  @ExperimentalChromeApi
  public override val domSnapshot: DOMSnapshotDomain by lazy { DOMSnapshotDomain(session) }

  /**
   * Query and modify DOM storage.
   */
  @ExperimentalChromeApi
  public override val domStorage: DOMStorageDomain by lazy { DOMStorageDomain(session) }

  @ExperimentalChromeApi
  public override val database: DatabaseDomain by lazy { DatabaseDomain(session) }

  @ExperimentalChromeApi
  public override val deviceOrientation: DeviceOrientationDomain by lazy {
      DeviceOrientationDomain(session) }

  /**
   * This domain emulates different environments for the page.
   */
  public override val emulation: EmulationDomain by lazy { EmulationDomain(session) }

  /**
   * This domain provides experimental commands only supported in headless mode.
   */
  @ExperimentalChromeApi
  public override val headlessExperimental: HeadlessExperimentalDomain by lazy {
      HeadlessExperimentalDomain(session) }

  /**
   * Input/Output operations for streams produced by DevTools.
   */
  public override val io: IODomain by lazy { IODomain(session) }

  @ExperimentalChromeApi
  public override val indexedDB: IndexedDBDomain by lazy { IndexedDBDomain(session) }

  public override val input: InputDomain by lazy { InputDomain(session) }

  @ExperimentalChromeApi
  public override val inspector: InspectorDomain by lazy { InspectorDomain(session) }

  @ExperimentalChromeApi
  public override val layerTree: LayerTreeDomain by lazy { LayerTreeDomain(session) }

  /**
   * Provides access to log entries.
   */
  public override val log: LogDomain by lazy { LogDomain(session) }

  @ExperimentalChromeApi
  public override val memory: MemoryDomain by lazy { MemoryDomain(session) }

  /**
   * Network domain allows tracking network activities of the page. It exposes information about
   * http,
   * file, data and other requests and responses, their headers, bodies, timing, etc.
   */
  public override val network: NetworkDomain by lazy { NetworkDomain(session) }

  /**
   * This domain provides various functionality related to drawing atop the inspected page.
   */
  @ExperimentalChromeApi
  public override val overlay: OverlayDomain by lazy { OverlayDomain(session) }

  /**
   * Actions and events related to the inspected page belong to the page domain.
   */
  public override val page: PageDomain by lazy { PageDomain(session) }

  public override val performance: PerformanceDomain by lazy { PerformanceDomain(session) }

  /**
   * Reporting of performance timeline events, as specified in
   * https://w3c.github.io/performance-timeline/#dom-performanceobserver.
   */
  @ExperimentalChromeApi
  public override val performanceTimeline: PerformanceTimelineDomain by lazy {
      PerformanceTimelineDomain(session) }

  /**
   * Security
   */
  public override val security: SecurityDomain by lazy { SecurityDomain(session) }

  @ExperimentalChromeApi
  public override val serviceWorker: ServiceWorkerDomain by lazy { ServiceWorkerDomain(session) }

  @ExperimentalChromeApi
  public override val storage: StorageDomain by lazy { StorageDomain(session) }

  /**
   * The SystemInfo domain defines methods and events for querying low-level system information.
   */
  @ExperimentalChromeApi
  public override val systemInfo: SystemInfoDomain by lazy { SystemInfoDomain(session) }

  /**
   * Supports additional targets discovery and allows to attach to them.
   */
  public override val target: TargetDomain by lazy { TargetDomain(session) }

  /**
   * The Tethering domain defines methods and events for browser port binding.
   */
  @ExperimentalChromeApi
  public override val tethering: TetheringDomain by lazy { TetheringDomain(session) }

  @ExperimentalChromeApi
  public override val tracing: TracingDomain by lazy { TracingDomain(session) }

  /**
   * A domain for letting clients substitute browser's network layer with client code.
   */
  public override val fetch: FetchDomain by lazy { FetchDomain(session) }

  /**
   * This domain allows inspection of Web Audio API.
   * https://webaudio.github.io/web-audio-api/
   */
  @ExperimentalChromeApi
  public override val webAudio: WebAudioDomain by lazy { WebAudioDomain(session) }

  /**
   * This domain allows configuring virtual authenticators to test the WebAuthn
   * API.
   */
  @ExperimentalChromeApi
  public override val webAuthn: WebAuthnDomain by lazy { WebAuthnDomain(session) }

  /**
   * This domain allows detailed inspection of media elements
   */
  @ExperimentalChromeApi
  public override val media: MediaDomain by lazy { MediaDomain(session) }

  /**
   * This domain is deprecated - use Runtime or Log instead.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public override val console: ConsoleDomain by lazy { ConsoleDomain(session) }

  /**
   * Debugger domain exposes JavaScript debugging capabilities. It allows setting and removing
   * breakpoints, stepping through execution, exploring stack traces, etc.
   */
  public override val debugger: DebuggerDomain by lazy { DebuggerDomain(session) }

  @ExperimentalChromeApi
  public override val heapProfiler: HeapProfilerDomain by lazy { HeapProfilerDomain(session) }

  public override val profiler: ProfilerDomain by lazy { ProfilerDomain(session) }

  /**
   * Runtime domain exposes JavaScript runtime by means of remote evaluation and mirror objects.
   * Evaluation results are returned as mirror object that expose object type, string representation
   * and unique identifier that can be used for further object reference. Original objects are
   * maintained in memory unless they are either explicitly released or are released along with the
   * other objects in their object group.
   */
  public override val runtime: RuntimeDomain by lazy { RuntimeDomain(session) }

  /**
   * This domain is deprecated.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public override val schema: SchemaDomain by lazy { SchemaDomain(session) }
}
