package org.hildan.chrome.devtools.domains.inspector.events

import kotlin.String
import kotlinx.serialization.Serializable

@Serializable
public sealed class InspectorEvent {
  /**
   * Fired when remote debugging connection is about to be terminated. Contains detach reason.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Inspector/#event-detached)
   */
  @Serializable
  public data class DetachedEvent(
    /**
     * The reason why connection has been terminated.
     */
    public val reason: String
  ) : InspectorEvent()

  /**
   * Fired when debugging target has crashed
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Inspector/#event-targetCrashed)
   */
  @Serializable
  public object TargetCrashedEvent : InspectorEvent()

  /**
   * Fired when debugging target has reloaded after crash
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Inspector/#event-targetReloadedAfterCrash)
   */
  @Serializable
  public object TargetReloadedAfterCrashEvent : InspectorEvent()
}
