package org.hildan.chrome.devtools.domains.serviceworker.events

import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerErrorMessage
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerRegistration
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerVersion

@Serializable
public sealed class ServiceWorkerEvent {
  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#event-workerErrorReported)
   */
  @Serializable
  public data class WorkerErrorReportedEvent(
    public val errorMessage: ServiceWorkerErrorMessage
  ) : ServiceWorkerEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#event-workerRegistrationUpdated)
   */
  @Serializable
  public data class WorkerRegistrationUpdatedEvent(
    public val registrations: List<ServiceWorkerRegistration>
  ) : ServiceWorkerEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#event-workerVersionUpdated)
   */
  @Serializable
  public data class WorkerVersionUpdatedEvent(
    public val versions: List<ServiceWorkerVersion>
  ) : ServiceWorkerEvent()
}
