package org.hildan.chrome.devtools.targets

import org.hildan.chrome.devtools.domains.browser.BrowserDomain
import org.hildan.chrome.devtools.domains.fetch.FetchDomain
import org.hildan.chrome.devtools.domains.io.IODomain
import org.hildan.chrome.devtools.domains.memory.MemoryDomain
import org.hildan.chrome.devtools.domains.security.SecurityDomain
import org.hildan.chrome.devtools.domains.storage.StorageDomain
import org.hildan.chrome.devtools.domains.systeminfo.SystemInfoDomain
import org.hildan.chrome.devtools.domains.target.TargetDomain
import org.hildan.chrome.devtools.domains.tethering.TetheringDomain
import org.hildan.chrome.devtools.domains.tracing.TracingDomain
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Represents the available domain APIs in Browser targets
 */
public interface BrowserTarget {
  /**
   * The Browser domain defines methods and events for browser managing.
   */
  public val browser: BrowserDomain

  /**
   * Input/Output operations for streams produced by DevTools.
   */
  public val io: IODomain

  @ExperimentalChromeApi
  public val memory: MemoryDomain

  /**
   * Security
   */
  public val security: SecurityDomain

  @ExperimentalChromeApi
  public val storage: StorageDomain

  /**
   * The SystemInfo domain defines methods and events for querying low-level system information.
   */
  @ExperimentalChromeApi
  public val systemInfo: SystemInfoDomain

  /**
   * Supports additional targets discovery and allows to attach to them.
   */
  public val target: TargetDomain

  /**
   * The Tethering domain defines methods and events for browser port binding.
   */
  @ExperimentalChromeApi
  public val tethering: TetheringDomain

  @ExperimentalChromeApi
  public val tracing: TracingDomain

  /**
   * A domain for letting clients substitute browser's network layer with client code.
   */
  public val fetch: FetchDomain
}
