@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.console

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlinx.coroutines.flow.Flow
import kotlinx.serialization.DeserializationStrategy
import kotlinx.serialization.serializer
import org.hildan.chrome.devtools.domains.console.events.ConsoleEvent
import org.hildan.chrome.devtools.protocol.ChromeDPSession

/**
 * This domain is deprecated - use Runtime or Log instead.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console)
 */
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public class ConsoleDomain internal constructor(
  private val session: ChromeDPSession
) {
  /**
   * Mapping between events and their deserializer.
   */
  private val deserializersByEventName: Map<String, DeserializationStrategy<out ConsoleEvent>> =
      mapOf(
      "Console.messageAdded" to serializer<ConsoleEvent.MessageAddedEvent>(),
      )

  /**
   * Subscribes to all events related to this domain.
   */
  public fun events(): Flow<ConsoleEvent> = session.events(deserializersByEventName)

  /**
   * Issued when new console message is added.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#event-messageAdded)
   */
  public fun messageAdded(): Flow<ConsoleEvent.MessageAddedEvent> =
      session.events("Console.messageAdded")

  /**
   * Does nothing.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#method-clearMessages)
   */
  public suspend fun clearMessages(): Unit = session.request("Console.clearMessages", Unit)

  /**
   * Disables console domain, prevents further console messages from being reported to the client.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#method-disable)
   */
  public suspend fun disable(): Unit = session.request("Console.disable", Unit)

  /**
   * Enables console domain, sends the messages collected so far to the client by means of the
   * `messageAdded` notification.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#method-enable)
   */
  public suspend fun enable(): Unit = session.request("Console.enable", Unit)
}
