@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.css.events

import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.css.CSSStyleSheetHeader
import org.hildan.chrome.devtools.domains.css.FontFace
import org.hildan.chrome.devtools.domains.css.StyleSheetId

@Serializable
public sealed class CSSEvent {
  /**
   * Fires whenever a web font is updated.  A non-empty font parameter indicates a successfully
   * loaded
   * web font
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/CSS/#event-fontsUpdated)
   */
  @Serializable
  public data class FontsUpdatedEvent(
    /**
     * The web font that has loaded.
     */
    public val font: FontFace? = null
  ) : CSSEvent()

  /**
   * Fires whenever a MediaQuery result changes (for example, after a browser window has been
   * resized.) The current implementation considers only viewport-dependent media features.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/CSS/#event-mediaQueryResultChanged)
   */
  @Serializable
  public object MediaQueryResultChangedEvent : CSSEvent()

  /**
   * Fired whenever an active document stylesheet is added.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/CSS/#event-styleSheetAdded)
   */
  @Serializable
  public data class StyleSheetAddedEvent(
    /**
     * Added stylesheet metainfo.
     */
    public val header: CSSStyleSheetHeader
  ) : CSSEvent()

  /**
   * Fired whenever a stylesheet is changed as a result of the client operation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/CSS/#event-styleSheetChanged)
   */
  @Serializable
  public data class StyleSheetChangedEvent(
    public val styleSheetId: StyleSheetId
  ) : CSSEvent()

  /**
   * Fired whenever an active document stylesheet is removed.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/CSS/#event-styleSheetRemoved)
   */
  @Serializable
  public data class StyleSheetRemovedEvent(
    /**
     * Identifier of the removed stylesheet.
     */
    public val styleSheetId: StyleSheetId
  ) : CSSEvent()
}
