@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.performance.events

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.performance.Metric

@Serializable
public sealed class PerformanceEvent {
  /**
   * Current values of the metrics.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Performance/#event-metrics)
   */
  @Serializable
  public data class MetricsEvent(
    /**
     * Current values of the metrics.
     */
    public val metrics: List<Metric>,
    /**
     * Timestamp title.
     */
    public val title: String
  ) : PerformanceEvent()
}
