@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.storage

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Enum of possible storage types.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Storage/#type-StorageType)
 */
@Serializable
public enum class StorageType {
  appcache,
  cookies,
  file_systems,
  indexeddb,
  local_storage,
  shader_cache,
  websql,
  service_workers,
  cache_storage,
  all,
  other,
}

/**
 * Usage for a storage type.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Storage/#type-UsageForType)
 */
@Serializable
public data class UsageForType(
  /**
   * Name of storage type.
   */
  public val storageType: StorageType,
  /**
   * Storage usage (bytes).
   */
  public val usage: Double
)

/**
 * Pair of issuer origin and number of available (signed, but not used) Trust
 * Tokens from that issuer.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Storage/#type-TrustTokens)
 */
@ExperimentalChromeApi
@Serializable
public data class TrustTokens(
  public val issuerOrigin: String,
  public val count: Double
)
