@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.targets

import kotlin.Deprecated
import kotlin.Suppress
import org.hildan.chrome.devtools.domains.accessibility.AccessibilityDomain
import org.hildan.chrome.devtools.domains.animation.AnimationDomain
import org.hildan.chrome.devtools.domains.applicationcache.ApplicationCacheDomain
import org.hildan.chrome.devtools.domains.audits.AuditsDomain
import org.hildan.chrome.devtools.domains.backgroundservice.BackgroundServiceDomain
import org.hildan.chrome.devtools.domains.browser.BrowserDomain
import org.hildan.chrome.devtools.domains.cachestorage.CacheStorageDomain
import org.hildan.chrome.devtools.domains.cast.CastDomain
import org.hildan.chrome.devtools.domains.console.ConsoleDomain
import org.hildan.chrome.devtools.domains.css.CSSDomain
import org.hildan.chrome.devtools.domains.database.DatabaseDomain
import org.hildan.chrome.devtools.domains.debugger.DebuggerDomain
import org.hildan.chrome.devtools.domains.deviceorientation.DeviceOrientationDomain
import org.hildan.chrome.devtools.domains.dom.DOMDomain
import org.hildan.chrome.devtools.domains.domdebugger.DOMDebuggerDomain
import org.hildan.chrome.devtools.domains.domsnapshot.DOMSnapshotDomain
import org.hildan.chrome.devtools.domains.domstorage.DOMStorageDomain
import org.hildan.chrome.devtools.domains.emulation.EmulationDomain
import org.hildan.chrome.devtools.domains.fetch.FetchDomain
import org.hildan.chrome.devtools.domains.headlessexperimental.HeadlessExperimentalDomain
import org.hildan.chrome.devtools.domains.heapprofiler.HeapProfilerDomain
import org.hildan.chrome.devtools.domains.indexeddb.IndexedDBDomain
import org.hildan.chrome.devtools.domains.input.InputDomain
import org.hildan.chrome.devtools.domains.inspector.InspectorDomain
import org.hildan.chrome.devtools.domains.io.IODomain
import org.hildan.chrome.devtools.domains.layertree.LayerTreeDomain
import org.hildan.chrome.devtools.domains.log.LogDomain
import org.hildan.chrome.devtools.domains.media.MediaDomain
import org.hildan.chrome.devtools.domains.memory.MemoryDomain
import org.hildan.chrome.devtools.domains.network.NetworkDomain
import org.hildan.chrome.devtools.domains.overlay.OverlayDomain
import org.hildan.chrome.devtools.domains.page.PageDomain
import org.hildan.chrome.devtools.domains.performance.PerformanceDomain
import org.hildan.chrome.devtools.domains.performancetimeline.PerformanceTimelineDomain
import org.hildan.chrome.devtools.domains.profiler.ProfilerDomain
import org.hildan.chrome.devtools.domains.runtime.RuntimeDomain
import org.hildan.chrome.devtools.domains.schema.SchemaDomain
import org.hildan.chrome.devtools.domains.security.SecurityDomain
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerDomain
import org.hildan.chrome.devtools.domains.storage.StorageDomain
import org.hildan.chrome.devtools.domains.systeminfo.SystemInfoDomain
import org.hildan.chrome.devtools.domains.target.TargetDomain
import org.hildan.chrome.devtools.domains.tethering.TetheringDomain
import org.hildan.chrome.devtools.domains.tracing.TracingDomain
import org.hildan.chrome.devtools.domains.webaudio.WebAudioDomain
import org.hildan.chrome.devtools.domains.webauthn.WebAuthnDomain
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Represents the available domain APIs in AllDomains targets
 */
public interface AllDomainsTarget {
  @ExperimentalChromeApi
  public val accessibility: AccessibilityDomain

  @ExperimentalChromeApi
  public val animation: AnimationDomain

  @ExperimentalChromeApi
  public val applicationCache: ApplicationCacheDomain

  /**
   * Audits domain allows investigation of page violations and possible improvements.
   */
  @ExperimentalChromeApi
  public val audits: AuditsDomain

  /**
   * Defines events for background web platform features.
   */
  @ExperimentalChromeApi
  public val backgroundService: BackgroundServiceDomain

  /**
   * The Browser domain defines methods and events for browser managing.
   */
  public val browser: BrowserDomain

  /**
   * This domain exposes CSS read/write operations. All CSS objects (stylesheets, rules, and styles)
   * have an associated `id` used in subsequent operations on the related object. Each object type
   * has
   * a specific `id` structure, and those are not interchangeable between objects of different
   * kinds.
   * CSS objects can be loaded using the `get*ForNode()` calls (which accept a DOM node id). A
   * client
   * can also keep track of stylesheets via the `styleSheetAdded`/`styleSheetRemoved` events and
   * subsequently load the required stylesheet contents using the `getStyleSheet[Text]()` methods.
   */
  @ExperimentalChromeApi
  public val css: CSSDomain

  @ExperimentalChromeApi
  public val cacheStorage: CacheStorageDomain

  /**
   * A domain for interacting with Cast, Presentation API, and Remote Playback API
   * functionalities.
   */
  @ExperimentalChromeApi
  public val cast: CastDomain

  /**
   * This domain exposes DOM read/write operations. Each DOM Node is represented with its mirror
   * object
   * that has an `id`. This `id` can be used to get additional information on the Node, resolve it
   * into
   * the JavaScript object wrapper, etc. It is important that client receives DOM events only for
   * the
   * nodes that are known to the client. Backend keeps track of the nodes that were sent to the
   * client
   * and never sends the same node twice. It is client's responsibility to collect information about
   * the nodes that were sent to the client.<p>Note that `iframe` owner elements will return
   * corresponding document elements as their child nodes.</p>
   */
  public val dom: DOMDomain

  /**
   * DOM debugging allows setting breakpoints on particular DOM operations and events. JavaScript
   * execution will stop on these operations as if there was a regular breakpoint set.
   */
  public val domDebugger: DOMDebuggerDomain

  /**
   * This domain facilitates obtaining document snapshots with DOM, layout, and style information.
   */
  @ExperimentalChromeApi
  public val domSnapshot: DOMSnapshotDomain

  /**
   * Query and modify DOM storage.
   */
  @ExperimentalChromeApi
  public val domStorage: DOMStorageDomain

  @ExperimentalChromeApi
  public val database: DatabaseDomain

  @ExperimentalChromeApi
  public val deviceOrientation: DeviceOrientationDomain

  /**
   * This domain emulates different environments for the page.
   */
  public val emulation: EmulationDomain

  /**
   * This domain provides experimental commands only supported in headless mode.
   */
  @ExperimentalChromeApi
  public val headlessExperimental: HeadlessExperimentalDomain

  /**
   * Input/Output operations for streams produced by DevTools.
   */
  public val io: IODomain

  @ExperimentalChromeApi
  public val indexedDB: IndexedDBDomain

  public val input: InputDomain

  @ExperimentalChromeApi
  public val inspector: InspectorDomain

  @ExperimentalChromeApi
  public val layerTree: LayerTreeDomain

  /**
   * Provides access to log entries.
   */
  public val log: LogDomain

  @ExperimentalChromeApi
  public val memory: MemoryDomain

  /**
   * Network domain allows tracking network activities of the page. It exposes information about
   * http,
   * file, data and other requests and responses, their headers, bodies, timing, etc.
   */
  public val network: NetworkDomain

  /**
   * This domain provides various functionality related to drawing atop the inspected page.
   */
  @ExperimentalChromeApi
  public val overlay: OverlayDomain

  /**
   * Actions and events related to the inspected page belong to the page domain.
   */
  public val page: PageDomain

  public val performance: PerformanceDomain

  /**
   * Reporting of performance timeline events, as specified in
   * https://w3c.github.io/performance-timeline/#dom-performanceobserver.
   */
  @ExperimentalChromeApi
  public val performanceTimeline: PerformanceTimelineDomain

  /**
   * Security
   */
  public val security: SecurityDomain

  @ExperimentalChromeApi
  public val serviceWorker: ServiceWorkerDomain

  @ExperimentalChromeApi
  public val storage: StorageDomain

  /**
   * The SystemInfo domain defines methods and events for querying low-level system information.
   */
  @ExperimentalChromeApi
  public val systemInfo: SystemInfoDomain

  /**
   * Supports additional targets discovery and allows to attach to them.
   */
  public val target: TargetDomain

  /**
   * The Tethering domain defines methods and events for browser port binding.
   */
  @ExperimentalChromeApi
  public val tethering: TetheringDomain

  @ExperimentalChromeApi
  public val tracing: TracingDomain

  /**
   * A domain for letting clients substitute browser's network layer with client code.
   */
  public val fetch: FetchDomain

  /**
   * This domain allows inspection of Web Audio API.
   * https://webaudio.github.io/web-audio-api/
   */
  @ExperimentalChromeApi
  public val webAudio: WebAudioDomain

  /**
   * This domain allows configuring virtual authenticators to test the WebAuthn
   * API.
   */
  @ExperimentalChromeApi
  public val webAuthn: WebAuthnDomain

  /**
   * This domain allows detailed inspection of media elements
   */
  @ExperimentalChromeApi
  public val media: MediaDomain

  /**
   * This domain is deprecated - use Runtime or Log instead.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val console: ConsoleDomain

  /**
   * Debugger domain exposes JavaScript debugging capabilities. It allows setting and removing
   * breakpoints, stepping through execution, exploring stack traces, etc.
   */
  public val debugger: DebuggerDomain

  @ExperimentalChromeApi
  public val heapProfiler: HeapProfilerDomain

  public val profiler: ProfilerDomain

  /**
   * Runtime domain exposes JavaScript runtime by means of remote evaluation and mirror objects.
   * Evaluation results are returned as mirror object that expose object type, string representation
   * and unique identifier that can be used for further object reference. Original objects are
   * maintained in memory unless they are either explicitly released or are released along with the
   * other objects in their object group.
   */
  public val runtime: RuntimeDomain

  /**
   * This domain is deprecated.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val schema: SchemaDomain
}
