@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.targets

import kotlin.Suppress
import org.hildan.chrome.devtools.domains.io.IODomain
import org.hildan.chrome.devtools.domains.network.NetworkDomain
import org.hildan.chrome.devtools.domains.target.TargetDomain

/**
 * Represents the available domain APIs in Worker targets
 */
public interface WorkerTarget {
  /**
   * Input/Output operations for streams produced by DevTools.
   */
  public val io: IODomain

  /**
   * Network domain allows tracking network activities of the page. It exposes information about
   * http,
   * file, data and other requests and responses, their headers, bodies, timing, etc.
   */
  public val network: NetworkDomain

  /**
   * Supports additional targets discovery and allows to attach to them.
   */
  public val target: TargetDomain
}
