@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.backgroundservice.events

import kotlin.Boolean
import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.backgroundservice.ServiceName

@Serializable
public sealed class BackgroundServiceEvent {
  /**
   * Called when the recording state for the service has been updated.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#event-recordingStateChanged)
   */
  @Serializable
  public data class RecordingStateChangedEvent(
    public val isRecording: Boolean,
    public val service: ServiceName
  ) : BackgroundServiceEvent()

  /**
   * Called with all existing backgroundServiceEvents when enabled, and all new
   * events afterwards if enabled and recording.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#event-backgroundServiceEventReceived)
   */
  @Serializable
  public data class BackgroundServiceEventReceivedEvent(
    public val backgroundServiceEvent:
        org.hildan.chrome.devtools.domains.backgroundservice.BackgroundServiceEvent
  ) : BackgroundServiceEvent()
}
