@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.domstorage.events

import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.domstorage.StorageId

@Serializable
public sealed class DOMStorageEvent {
  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMStorage/#event-domStorageItemAdded)
   */
  @Serializable
  public data class DomStorageItemAddedEvent(
    public val storageId: StorageId,
    public val key: String,
    public val newValue: String
  ) : DOMStorageEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMStorage/#event-domStorageItemRemoved)
   */
  @Serializable
  public data class DomStorageItemRemovedEvent(
    public val storageId: StorageId,
    public val key: String
  ) : DOMStorageEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMStorage/#event-domStorageItemUpdated)
   */
  @Serializable
  public data class DomStorageItemUpdatedEvent(
    public val storageId: StorageId,
    public val key: String,
    public val oldValue: String,
    public val newValue: String
  ) : DOMStorageEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMStorage/#event-domStorageItemsCleared)
   */
  @Serializable
  public data class DomStorageItemsClearedEvent(
    public val storageId: StorageId
  ) : DOMStorageEvent()
}
