@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.database

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable

/**
 * Unique identifier of Database object.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Database/#type-DatabaseId)
 */
public typealias DatabaseId = String

/**
 * Database object.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Database/#type-Database)
 */
@Serializable
public data class Database(
  /**
   * Database ID.
   */
  public val id: DatabaseId,
  /**
   * Database domain.
   */
  public val domain: String,
  /**
   * Database name.
   */
  public val name: String,
  /**
   * Database version.
   */
  public val version: String
)

/**
 * Database error.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Database/#type-Error)
 */
@Serializable
public data class Error(
  /**
   * Error message.
   */
  public val message: String,
  /**
   * Error code.
   */
  public val code: Int
)
