@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.cast

import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Cast/#type-Sink)
 */
@Serializable
public data class Sink(
  public val name: String,
  public val id: String,
  /**
   * Text describing the current session. Present only if there is an active
   * session on the sink.
   */
  public val session: String? = null
)
