@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.storage.events

import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable

@Serializable
public sealed class StorageEvent {
  /**
   * A cache's contents have been modified.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Storage/#event-cacheStorageContentUpdated)
   */
  @Serializable
  public data class CacheStorageContentUpdatedEvent(
    /**
     * Origin to update.
     */
    public val origin: String,
    /**
     * Name of cache in origin.
     */
    public val cacheName: String
  ) : StorageEvent()

  /**
   * A cache has been added/deleted.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Storage/#event-cacheStorageListUpdated)
   */
  @Serializable
  public data class CacheStorageListUpdatedEvent(
    /**
     * Origin to update.
     */
    public val origin: String
  ) : StorageEvent()

  /**
   * The origin's IndexedDB object store has been modified.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Storage/#event-indexedDBContentUpdated)
   */
  @Serializable
  public data class IndexedDBContentUpdatedEvent(
    /**
     * Origin to update.
     */
    public val origin: String,
    /**
     * Database to update.
     */
    public val databaseName: String,
    /**
     * ObjectStore to update.
     */
    public val objectStoreName: String
  ) : StorageEvent()

  /**
   * The origin's IndexedDB database list has been modified.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Storage/#event-indexedDBListUpdated)
   */
  @Serializable
  public data class IndexedDBListUpdatedEvent(
    /**
     * Origin to update.
     */
    public val origin: String
  ) : StorageEvent()
}
