package org.hildan.chrome.devtools.domains.applicationcache.events

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.page.FrameId

@Serializable
public sealed class ApplicationCacheEvent {
  @Serializable
  public data class ApplicationCacheStatusUpdatedEvent(
    /**
     * Identifier of the frame containing document whose application cache updated status.
     */
    public val frameId: FrameId,
    /**
     * Manifest URL.
     */
    public val manifestURL: String,
    /**
     * Updated application cache status.
     */
    public val status: Int
  ) : ApplicationCacheEvent()

  @Serializable
  public data class NetworkStateUpdatedEvent(
    public val isNowOnline: Boolean
  ) : ApplicationCacheEvent()
}
