package org.hildan.chrome.devtools.domains.backgroundservice

import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.network.TimeSinceEpoch
import org.hildan.chrome.devtools.domains.serviceworker.RegistrationID

/**
 * The Background Service that will be associated with the commands/events.
 * Every Background Service operates independently, but they share the same
 * API.
 */
@Serializable
public enum class ServiceName {
  backgroundFetch,
  backgroundSync,
  pushMessaging,
  notifications,
  paymentHandler,
  periodicBackgroundSync,
}

/**
 * A key-value pair for additional event information to pass along.
 */
@Serializable
public data class EventMetadata(
  public val key: String,
  public val value: String
)

@Serializable
public data class BackgroundServiceEvent(
  /**
   * Timestamp of the event (in seconds).
   */
  public val timestamp: TimeSinceEpoch,
  /**
   * The origin this event belongs to.
   */
  public val origin: String,
  /**
   * The Service Worker ID that initiated the event.
   */
  public val serviceWorkerRegistrationId: RegistrationID,
  /**
   * The Background Service this event belongs to.
   */
  public val service: ServiceName,
  /**
   * A description of the event.
   */
  public val eventName: String,
  /**
   * An identifier that groups related events together.
   */
  public val instanceId: String,
  /**
   * A list of event-specific information.
   */
  public val eventMetadata: List<EventMetadata>
)
