package org.hildan.chrome.devtools.domains.cachestorage

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable

/**
 * Unique identifier of the Cache object.
 */
public typealias CacheId = String

/**
 * type of HTTP response cached
 */
@Serializable
public enum class CachedResponseType {
  basic,
  cors,
  default,
  error,
  opaqueResponse,
  opaqueRedirect,
}

/**
 * Data entry.
 */
@Serializable
public data class DataEntry(
  /**
   * Request URL.
   */
  public val requestURL: String,
  /**
   * Request method.
   */
  public val requestMethod: String,
  /**
   * Request headers
   */
  public val requestHeaders: List<Header>,
  /**
   * Number of seconds since epoch.
   */
  public val responseTime: Double,
  /**
   * HTTP response status code.
   */
  public val responseStatus: Int,
  /**
   * HTTP response status text.
   */
  public val responseStatusText: String,
  /**
   * HTTP response type
   */
  public val responseType: CachedResponseType,
  /**
   * Response headers
   */
  public val responseHeaders: List<Header>
)

/**
 * Cache identifier.
 */
@Serializable
public data class Cache(
  /**
   * An opaque unique id of the cache.
   */
  public val cacheId: CacheId,
  /**
   * Security origin of the cache.
   */
  public val securityOrigin: String,
  /**
   * The name of the cache.
   */
  public val cacheName: String
)

@Serializable
public data class Header(
  public val name: String,
  public val value: String
)

/**
 * Cached response
 */
@Serializable
public data class CachedResponse(
  /**
   * Entry content, base64-encoded.
   */
  public val body: String
)
