package org.hildan.chrome.devtools.domains.css.events

import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.css.CSSStyleSheetHeader
import org.hildan.chrome.devtools.domains.css.FontFace
import org.hildan.chrome.devtools.domains.css.StyleSheetId

@Serializable
public sealed class CSSEvent {
  @Serializable
  public data class FontsUpdatedEvent(
    /**
     * The web font that has loaded.
     */
    public val font: FontFace? = null
  ) : CSSEvent()

  @Serializable
  public object MediaQueryResultChangedEvent : CSSEvent()

  @Serializable
  public data class StyleSheetAddedEvent(
    /**
     * Added stylesheet metainfo.
     */
    public val header: CSSStyleSheetHeader
  ) : CSSEvent()

  @Serializable
  public data class StyleSheetChangedEvent(
    public val styleSheetId: StyleSheetId
  ) : CSSEvent()

  @Serializable
  public data class StyleSheetRemovedEvent(
    /**
     * Identifier of the removed stylesheet.
     */
    public val styleSheetId: StyleSheetId
  ) : CSSEvent()
}
