package org.hildan.chrome.devtools.domains.database

import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable

/**
 * Unique identifier of Database object.
 */
public typealias DatabaseId = String

/**
 * Database object.
 */
@Serializable
public data class Database(
  /**
   * Database ID.
   */
  public val id: DatabaseId,
  /**
   * Database domain.
   */
  public val domain: String,
  /**
   * Database name.
   */
  public val name: String,
  /**
   * Database version.
   */
  public val version: String
)

/**
 * Database error.
 */
@Serializable
public data class Error(
  /**
   * Error message.
   */
  public val message: String,
  /**
   * Error code.
   */
  public val code: Int
)
