package org.hildan.chrome.devtools.domains.deviceorientation

import kotlin.Double
import kotlin.Unit
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ChromeDPSession
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Request object containing input parameters for the
 * [DeviceOrientationDomain.setDeviceOrientationOverride] command.
 */
@Serializable
public data class SetDeviceOrientationOverrideRequest(
  /**
   * Mock alpha
   */
  public val alpha: Double,
  /**
   * Mock beta
   */
  public val beta: Double,
  /**
   * Mock gamma
   */
  public val gamma: Double
)

@ExperimentalChromeApi
public class DeviceOrientationDomain internal constructor(
  private val session: ChromeDPSession
) {
  /**
   * Clears the overridden Device Orientation.
   */
  public suspend fun clearDeviceOrientationOverride(): Unit =
      session.request("DeviceOrientation.clearDeviceOrientationOverride", Unit)

  /**
   * Overrides the Device Orientation.
   */
  public suspend fun setDeviceOrientationOverride(input: SetDeviceOrientationOverrideRequest): Unit
      = session.request("DeviceOrientation.setDeviceOrientationOverride", input)
}
