package org.hildan.chrome.devtools.domains.dom.events

import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.dom.BackendNode
import org.hildan.chrome.devtools.domains.dom.Node
import org.hildan.chrome.devtools.domains.dom.NodeId

@Serializable
public sealed class DOMEvent {
  @Serializable
  public data class AttributeModifiedEvent(
    /**
     * Id of the node that has changed.
     */
    public val nodeId: NodeId,
    /**
     * Attribute name.
     */
    public val name: String,
    /**
     * Attribute value.
     */
    public val value: String
  ) : DOMEvent()

  @Serializable
  public data class AttributeRemovedEvent(
    /**
     * Id of the node that has changed.
     */
    public val nodeId: NodeId,
    /**
     * A ttribute name.
     */
    public val name: String
  ) : DOMEvent()

  @Serializable
  public data class CharacterDataModifiedEvent(
    /**
     * Id of the node that has changed.
     */
    public val nodeId: NodeId,
    /**
     * New text value.
     */
    public val characterData: String
  ) : DOMEvent()

  @Serializable
  public data class ChildNodeCountUpdatedEvent(
    /**
     * Id of the node that has changed.
     */
    public val nodeId: NodeId,
    /**
     * New node count.
     */
    public val childNodeCount: Int
  ) : DOMEvent()

  @Serializable
  public data class ChildNodeInsertedEvent(
    /**
     * Id of the node that has changed.
     */
    public val parentNodeId: NodeId,
    /**
     * If of the previous siblint.
     */
    public val previousNodeId: NodeId,
    /**
     * Inserted node data.
     */
    public val node: Node
  ) : DOMEvent()

  @Serializable
  public data class ChildNodeRemovedEvent(
    /**
     * Parent id.
     */
    public val parentNodeId: NodeId,
    /**
     * Id of the node that has been removed.
     */
    public val nodeId: NodeId
  ) : DOMEvent()

  @Serializable
  public data class DistributedNodesUpdatedEvent(
    /**
     * Insertion point where distrubuted nodes were updated.
     */
    public val insertionPointId: NodeId,
    /**
     * Distributed nodes for given insertion point.
     */
    public val distributedNodes: List<BackendNode>
  ) : DOMEvent()

  @Serializable
  public object DocumentUpdatedEvent : DOMEvent()

  @Serializable
  public data class InlineStyleInvalidatedEvent(
    /**
     * Ids of the nodes for which the inline styles have been invalidated.
     */
    public val nodeIds: List<NodeId>
  ) : DOMEvent()

  @Serializable
  public data class PseudoElementAddedEvent(
    /**
     * Pseudo element's parent element id.
     */
    public val parentId: NodeId,
    /**
     * The added pseudo element.
     */
    public val pseudoElement: Node
  ) : DOMEvent()

  @Serializable
  public data class PseudoElementRemovedEvent(
    /**
     * Pseudo element's parent element id.
     */
    public val parentId: NodeId,
    /**
     * The removed pseudo element id.
     */
    public val pseudoElementId: NodeId
  ) : DOMEvent()

  @Serializable
  public data class SetChildNodesEvent(
    /**
     * Parent node id to populate with children.
     */
    public val parentId: NodeId,
    /**
     * Child nodes array.
     */
    public val nodes: List<Node>
  ) : DOMEvent()

  @Serializable
  public data class ShadowRootPoppedEvent(
    /**
     * Host element id.
     */
    public val hostId: NodeId,
    /**
     * Shadow root id.
     */
    public val rootId: NodeId
  ) : DOMEvent()

  @Serializable
  public data class ShadowRootPushedEvent(
    /**
     * Host element id.
     */
    public val hostId: NodeId,
    /**
     * Shadow root.
     */
    public val root: Node
  ) : DOMEvent()
}
