package org.hildan.chrome.devtools.domains.fetch.events

import kotlin.Int
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.fetch.AuthChallenge
import org.hildan.chrome.devtools.domains.fetch.HeaderEntry
import org.hildan.chrome.devtools.domains.fetch.RequestId
import org.hildan.chrome.devtools.domains.network.ErrorReason
import org.hildan.chrome.devtools.domains.network.Request
import org.hildan.chrome.devtools.domains.network.ResourceType
import org.hildan.chrome.devtools.domains.page.FrameId

@Serializable
public sealed class FetchEvent {
  @Serializable
  public data class RequestPausedEvent(
    /**
     * Each request the page makes will have a unique id.
     */
    public val requestId: RequestId,
    /**
     * The details of the request.
     */
    public val request: Request,
    /**
     * The id of the frame that initiated the request.
     */
    public val frameId: FrameId,
    /**
     * How the requested resource will be used.
     */
    public val resourceType: ResourceType,
    /**
     * Response error if intercepted at response stage.
     */
    public val responseErrorReason: ErrorReason? = null,
    /**
     * Response code if intercepted at response stage.
     */
    public val responseStatusCode: Int? = null,
    /**
     * Response headers if intercepted at the response stage.
     */
    public val responseHeaders: List<HeaderEntry>? = null,
    /**
     * If the intercepted request had a corresponding Network.requestWillBeSent event fired for it,
     * then this networkId will be the same as the requestId present in the requestWillBeSent event.
     */
    public val networkId: RequestId? = null
  ) : FetchEvent()

  @Serializable
  public data class AuthRequiredEvent(
    /**
     * Each request the page makes will have a unique id.
     */
    public val requestId: RequestId,
    /**
     * The details of the request.
     */
    public val request: Request,
    /**
     * The id of the frame that initiated the request.
     */
    public val frameId: FrameId,
    /**
     * How the requested resource will be used.
     */
    public val resourceType: ResourceType,
    /**
     * Details of the Authorization Challenge encountered.
     * If this is set, client should respond with continueRequest that
     * contains AuthChallengeResponse.
     */
    public val authChallenge: AuthChallenge
  ) : FetchEvent()
}
