package org.hildan.chrome.devtools.domains.media

import kotlin.Double
import kotlin.String
import kotlinx.serialization.Serializable

/**
 * Players will get an ID that is unique within the agent context.
 */
public typealias PlayerId = String

public typealias Timestamp = Double

/**
 * Have one type per entry in MediaLogRecord::Type
 * Corresponds to kMessage
 */
@Serializable
public data class PlayerMessage(
  /**
   * Keep in sync with MediaLogMessageLevel
   * We are currently keeping the message level 'error' separate from the
   * PlayerError type because right now they represent different things,
   * this one being a DVLOG(ERROR) style log message that gets printed
   * based on what log level is selected in the UI, and the other is a
   * representation of a media::PipelineStatus object. Soon however we're
   * going to be moving away from using PipelineStatus for errors and
   * introducing a new error type which should hopefully let us integrate
   * the error log level into the PlayerError type.
   */
  public val level: String,
  public val message: String
)

/**
 * Corresponds to kMediaPropertyChange
 */
@Serializable
public data class PlayerProperty(
  public val name: String,
  public val value: String
)

/**
 * Corresponds to kMediaEventTriggered
 */
@Serializable
public data class PlayerEvent(
  public val timestamp: Timestamp,
  public val value: String
)

/**
 * Corresponds to kMediaError
 */
@Serializable
public data class PlayerError(
  public val type: String,
  /**
   * When this switches to using media::Status instead of PipelineStatus
   * we can remove "errorCode" and replace it with the fields from
   * a Status instance. This also seems like a duplicate of the error
   * level enum - there is a todo bug to have that level removed and
   * use this instead. (crbug.com/1068454)
   */
  public val errorCode: String
)
