package org.hildan.chrome.devtools.domains.media.events

import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.media.PlayerError
import org.hildan.chrome.devtools.domains.media.PlayerEvent
import org.hildan.chrome.devtools.domains.media.PlayerId
import org.hildan.chrome.devtools.domains.media.PlayerMessage
import org.hildan.chrome.devtools.domains.media.PlayerProperty

@Serializable
public sealed class MediaEvent {
  @Serializable
  public data class PlayerPropertiesChangedEvent(
    public val playerId: PlayerId,
    public val properties: List<PlayerProperty>
  ) : MediaEvent()

  @Serializable
  public data class PlayerEventsAddedEvent(
    public val playerId: PlayerId,
    public val events: List<PlayerEvent>
  ) : MediaEvent()

  @Serializable
  public data class PlayerMessagesLoggedEvent(
    public val playerId: PlayerId,
    public val messages: List<PlayerMessage>
  ) : MediaEvent()

  @Serializable
  public data class PlayerErrorsRaisedEvent(
    public val playerId: PlayerId,
    public val errors: List<PlayerError>
  ) : MediaEvent()

  @Serializable
  public data class PlayersCreatedEvent(
    public val players: List<PlayerId>
  ) : MediaEvent()
}
