package org.hildan.chrome.devtools.domains.performance.events

import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.performance.Metric

@Serializable
public sealed class PerformanceEvent {
  @Serializable
  public data class MetricsEvent(
    /**
     * Current values of the metrics.
     */
    public val metrics: List<Metric>,
    /**
     * Timestamp title.
     */
    public val title: String
  ) : PerformanceEvent()
}
