package org.hildan.chrome.devtools.domains.profiler.events

import kotlin.Double
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.debugger.Location
import org.hildan.chrome.devtools.domains.profiler.Profile
import org.hildan.chrome.devtools.domains.profiler.ScriptCoverage

@Serializable
public sealed class ProfilerEvent {
  @Serializable
  public data class ConsoleProfileFinishedEvent(
    public val id: String,
    /**
     * Location of console.profileEnd().
     */
    public val location: Location,
    public val profile: Profile,
    /**
     * Profile title passed as an argument to console.profile().
     */
    public val title: String? = null
  ) : ProfilerEvent()

  @Serializable
  public data class ConsoleProfileStartedEvent(
    public val id: String,
    /**
     * Location of console.profile().
     */
    public val location: Location,
    /**
     * Profile title passed as an argument to console.profile().
     */
    public val title: String? = null
  ) : ProfilerEvent()

  @Serializable
  public data class PreciseCoverageDeltaUpdateEvent(
    /**
     * Monotonically increasing time (in seconds) when the coverage update was taken in the backend.
     */
    public val timestamp: Double,
    /**
     * Identifier for distinguishing coverage events.
     */
    public val occassion: String,
    /**
     * Coverage data for the current isolate.
     */
    public val result: List<ScriptCoverage>
  ) : ProfilerEvent()
}
