package org.hildan.chrome.devtools.domains.schema

import kotlin.Deprecated
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ChromeDPSession

/**
 * Response type for the [SchemaDomain.getDomains] command.
 */
@Serializable
public data class GetDomainsResponse(
  /**
   * List of supported domains.
   */
  public val domains: List<Domain>
)

/**
 * This domain is deprecated.
 */
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public class SchemaDomain internal constructor(
  private val session: ChromeDPSession
) {
  /**
   * Returns supported domains.
   */
  public suspend fun getDomains(): GetDomainsResponse = session.request("Schema.getDomains", Unit)
}
