package org.hildan.chrome.devtools.domains.security.events

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.security.InsecureContentStatus
import org.hildan.chrome.devtools.domains.security.SecurityState
import org.hildan.chrome.devtools.domains.security.SecurityStateExplanation
import org.hildan.chrome.devtools.domains.security.VisibleSecurityState

@Serializable
public sealed class SecurityEvent {
  @Serializable
  public data class CertificateErrorEvent(
    /**
     * The ID of the event.
     */
    public val eventId: Int,
    /**
     * The type of the error.
     */
    public val errorType: String,
    /**
     * The url that was requested.
     */
    public val requestURL: String
  ) : SecurityEvent()

  @Serializable
  public data class VisibleSecurityStateChangedEvent(
    /**
     * Security state information about the page.
     */
    public val visibleSecurityState: VisibleSecurityState
  ) : SecurityEvent()

  @Serializable
  public data class SecurityStateChangedEvent(
    /**
     * Security state.
     */
    public val securityState: SecurityState,
    /**
     * True if the page was loaded over cryptographic transport such as HTTPS.
     */
    @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
    public val schemeIsCryptographic: Boolean,
    /**
     * List of explanations for the security state. If the overall security state is `insecure` or
     * `warning`, at least one corresponding explanation should be included.
     */
    public val explanations: List<SecurityStateExplanation>,
    /**
     * Information about insecure content on the page.
     */
    @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
    public val insecureContentStatus: InsecureContentStatus,
    /**
     * Overrides user-visible description of the state.
     */
    public val summary: String? = null
  ) : SecurityEvent()
}
