package org.hildan.chrome.devtools.domains.storage.events

import kotlin.String
import kotlinx.serialization.Serializable

@Serializable
public sealed class StorageEvent {
  @Serializable
  public data class CacheStorageContentUpdatedEvent(
    /**
     * Origin to update.
     */
    public val origin: String,
    /**
     * Name of cache in origin.
     */
    public val cacheName: String
  ) : StorageEvent()

  @Serializable
  public data class CacheStorageListUpdatedEvent(
    /**
     * Origin to update.
     */
    public val origin: String
  ) : StorageEvent()

  @Serializable
  public data class IndexedDBContentUpdatedEvent(
    /**
     * Origin to update.
     */
    public val origin: String,
    /**
     * Database to update.
     */
    public val databaseName: String,
    /**
     * ObjectStore to update.
     */
    public val objectStoreName: String
  ) : StorageEvent()

  @Serializable
  public data class IndexedDBListUpdatedEvent(
    /**
     * Origin to update.
     */
    public val origin: String
  ) : StorageEvent()
}
