package org.hildan.chrome.devtools.domains.systeminfo

import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ChromeDPSession
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Response type for the [SystemInfoDomain.getInfo] command.
 */
@Serializable
public data class GetInfoResponse(
  /**
   * Information about the GPUs on the system.
   */
  public val gpu: GPUInfo,
  /**
   * A platform-dependent description of the model of the machine. On Mac OS, this is, for
   * example, 'MacBookPro'. Will be the empty string if not supported.
   */
  public val modelName: String,
  /**
   * A platform-dependent description of the version of the machine. On Mac OS, this is, for
   * example, '10.1'. Will be the empty string if not supported.
   */
  public val modelVersion: String,
  /**
   * The command line string used to launch the browser. Will be the empty string if not
   * supported.
   */
  public val commandLine: String
)

/**
 * Response type for the [SystemInfoDomain.getProcessInfo] command.
 */
@Serializable
public data class GetProcessInfoResponse(
  /**
   * An array of process info blocks.
   */
  public val processInfo: List<ProcessInfo>
)

/**
 * The SystemInfo domain defines methods and events for querying low-level system information.
 */
@ExperimentalChromeApi
public class SystemInfoDomain internal constructor(
  private val session: ChromeDPSession
) {
  /**
   * Returns information about the system.
   */
  public suspend fun getInfo(): GetInfoResponse = session.request("SystemInfo.getInfo", Unit)

  /**
   * Returns information about all running processes.
   */
  public suspend fun getProcessInfo(): GetProcessInfoResponse =
      session.request("SystemInfo.getProcessInfo", Unit)
}
