package org.hildan.chrome.devtools.domains.tracing.events

import kotlin.Boolean
import kotlin.Double
import kotlin.collections.List
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement
import org.hildan.chrome.devtools.domains.io.StreamHandle
import org.hildan.chrome.devtools.domains.tracing.StreamCompression
import org.hildan.chrome.devtools.domains.tracing.StreamFormat

@Serializable
public sealed class TracingEvent {
  @Serializable
  public data class BufferUsageEvent(
    /**
     * A number in range [0..1] that indicates the used size of event buffer as a fraction of its
     * total size.
     */
    public val percentFull: Double? = null,
    /**
     * An approximate number of events in the trace log.
     */
    public val eventCount: Double? = null,
    /**
     * A number in range [0..1] that indicates the used size of event buffer as a fraction of its
     * total size.
     */
    public val value: Double? = null
  ) : TracingEvent()

  @Serializable
  public data class DataCollectedEvent(
    public val value: List<JsonElement>
  ) : TracingEvent()

  @Serializable
  public data class TracingCompleteEvent(
    /**
     * Indicates whether some trace data is known to have been lost, e.g. because the trace ring
     * buffer wrapped around.
     */
    public val dataLossOccurred: Boolean,
    /**
     * A handle of the stream that holds resulting trace data.
     */
    public val stream: StreamHandle? = null,
    /**
     * Trace data format of returned stream.
     */
    public val traceFormat: StreamFormat? = null,
    /**
     * Compression format of returned stream.
     */
    public val streamCompression: StreamCompression? = null
  ) : TracingEvent()
}
