package org.hildan.chrome.devtools.domains.animation

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.dom.BackendNodeId

/**
 * Animation instance.
 */
@Serializable
public data class Animation(
  /**
   * `Animation`'s id.
   */
  public val id: String,
  /**
   * `Animation`'s name.
   */
  public val name: String,
  /**
   * `Animation`'s internal paused state.
   */
  public val pausedState: Boolean,
  /**
   * `Animation`'s play state.
   */
  public val playState: String,
  /**
   * `Animation`'s playback rate.
   */
  public val playbackRate: Double,
  /**
   * `Animation`'s start time.
   */
  public val startTime: Double,
  /**
   * `Animation`'s current time.
   */
  public val currentTime: Double,
  /**
   * Animation type of `Animation`.
   */
  public val type: String,
  /**
   * `Animation`'s source animation node.
   */
  public val source: AnimationEffect? = null,
  /**
   * A unique ID for `Animation` representing the sources that triggered this CSS
   * animation/transition.
   */
  public val cssId: String? = null
)

/**
 * AnimationEffect instance
 */
@Serializable
public data class AnimationEffect(
  /**
   * `AnimationEffect`'s delay.
   */
  public val delay: Double,
  /**
   * `AnimationEffect`'s end delay.
   */
  public val endDelay: Double,
  /**
   * `AnimationEffect`'s iteration start.
   */
  public val iterationStart: Double,
  /**
   * `AnimationEffect`'s iterations.
   */
  public val iterations: Double,
  /**
   * `AnimationEffect`'s iteration duration.
   */
  public val duration: Double,
  /**
   * `AnimationEffect`'s playback direction.
   */
  public val direction: String,
  /**
   * `AnimationEffect`'s fill mode.
   */
  public val fill: String,
  /**
   * `AnimationEffect`'s target node.
   */
  public val backendNodeId: BackendNodeId? = null,
  /**
   * `AnimationEffect`'s keyframes.
   */
  public val keyframesRule: KeyframesRule? = null,
  /**
   * `AnimationEffect`'s timing function.
   */
  public val easing: String
)

/**
 * Keyframes Rule
 */
@Serializable
public data class KeyframesRule(
  /**
   * CSS keyframed animation's name.
   */
  public val name: String? = null,
  /**
   * List of animation keyframes.
   */
  public val keyframes: List<KeyframeStyle>
)

/**
 * Keyframe Style
 */
@Serializable
public data class KeyframeStyle(
  /**
   * Keyframe's time offset.
   */
  public val offset: String,
  /**
   * `AnimationEffect`'s timing function.
   */
  public val easing: String
)
