package org.hildan.chrome.devtools.domains.animation.events

import kotlin.String
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.animation.Animation

@Serializable
public sealed class AnimationEvent {
  @Serializable
  public data class AnimationCanceledEvent(
    /**
     * Id of the animation that was cancelled.
     */
    public val id: String
  ) : AnimationEvent()

  @Serializable
  public data class AnimationCreatedEvent(
    /**
     * Id of the animation that was created.
     */
    public val id: String
  ) : AnimationEvent()

  @Serializable
  public data class AnimationStartedEvent(
    /**
     * Animation that was started.
     */
    public val animation: Animation
  ) : AnimationEvent()
}
