package org.hildan.chrome.devtools.domains.backgroundservice.events

import kotlin.Boolean
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.backgroundservice.ServiceName

@Serializable
public sealed class BackgroundServiceEvent {
  @Serializable
  public data class RecordingStateChangedEvent(
    public val isRecording: Boolean,
    public val service: ServiceName
  ) : BackgroundServiceEvent()

  @Serializable
  public data class BackgroundServiceEventReceivedEvent(
    public val backgroundServiceEvent:
        org.hildan.chrome.devtools.domains.backgroundservice.BackgroundServiceEvent
  ) : BackgroundServiceEvent()
}
