package org.hildan.chrome.devtools.domains.cast.events

import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.cast.Sink

@Serializable
public sealed class CastEvent {
  @Serializable
  public data class SinksUpdatedEvent(
    public val sinks: List<Sink>
  ) : CastEvent()

  @Serializable
  public data class IssueUpdatedEvent(
    public val issueMessage: String
  ) : CastEvent()
}
